(defmeth selection-overlay-proto :do-click (x y m1 m2)
  (when (< 15 y 32)
        (send (send self :graph) :line-type 'solid)
        (let* ((graph (send self :graph))
               (hilight (send graph :points-selected))
               (link-list (remove 'nil (send graph :links)))
               (color  (send self :which-color x y))
               (symbol (send self :which-symbol x y)))
          (when (and hilight (or color symbol))
                (when color (send graph :point-color hilight color))
                (when symbol (send graph :point-symbol hilight symbol))
                (when link-list
                      (dolist (plot link-list)
                              ;(send plot :use-color t)
                              (when color (send plot :point-color hilight color))
                              (when symbol (send plot :point-symbol hilight symbol))
                              (when (member vista-scatterplot-proto (send plot :precedence-list))    
                            (and   (send plot :has-slot 'add-linear)   (send plot :clear-curves)))
                              (send plot :redraw-content)
                              (send plot :points-selected hilight)))
                (send graph :redraw-content)
                (send graph :points-selected hilight))
          )))

(defmeth graph-proto :make-two-plot-menus (title &key hotspot-items popup-items)
  "Args: TITLE &KEY HOTSPOT-ITEMS POPUP-ITEMS
  Makes pull-down and popup menus for plots and plotcells. TITLE is title of
  the menu if it appears in the menubar. HOTSPOT-ITEMS is the menu items for
  the pulldown that appears with a left-click on the menubar menu or the
  pull-down hotspot. POPUP-ITEMS is a set of  menu items that popup from the
  plot when the plot is right clicked."
;store items in a slot - create secondary items, store in slot
     (send self :make-hotspot-menu-items hotspot-items) 
     (send self :make-popup-menu-items popup-items) 
     (when (send self :menu)  ;remove menu from menubar so it can be popped up
           (send (send self :menu) :graph self)	
           (send (send self :menu) :remove))
     (defmeth self :do-click (x y m1 m2)
       (let* ((hotspot-menu-items (remove 'nil (send self :hotspot-menu-items))) ;PV 2010 add remove 'nil
              (popup-menu-items (remove 'nil (send self :popup-menu-items))); PV add remove 'nil
              (line-type (send self :line-type))
              (menu (send self :menu)))
	 (when menu (send menu :remove))
         (cond 
          ((and m1 m2)  
           ;(print "; cntl-right-click anywhere")
           (when (and hotspot-menu-items (> y 18))
           ;      (print "; cntl-right-click below menubar - switch to hotspot items")
                 (apply #'send menu :delete-items (send menu :items))
                 (apply #'send menu :append-items hotspot-menu-items)
                 (send menu :popup-menu x y self)))
          (m2   
           ;(print "; right-click anywhere")
           (when (and popup-items (> y 18))
           ;      (print "; right-click below menubar - switch to popup items")
                 (apply #'send menu :delete-items (send menu :items))
                 (apply #'send menu :append-items popup-menu-items)
                 (send menu :popup-menu x y self)))
          (t     
           ;(print "; left-click or control-left-click - switch to hotspot items")
           (apply #'send menu :delete-items (send menu :items))
           (apply #'send menu :append-items hotspot-menu-items)
           (call-next-method x y m1 m2)))
          (send self :menu menu)
          (send self :line-type line-type)
          )
         t)
    ;(terpri)
    (send self :menu))